package java.game.cars;

import java.util.*;
import java.util.resource.*;
import java.game.parts.bodypart.*;


public class Zed_FR_door extends FrontDoor
{
	public Zed_FR_door( int id )
	{
		super( id );
		carCategory = PACKAGE;
		name = "Zed front right door";

		value = 242;
	}
	
	public void addStockParts( int actcolor, float optical, float power )
	{
		super.addStockParts( actcolor, optical, power );

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_02.zed:0x000000BFr, "FR window", actcolor, optical, power );
			addPart( cars.cat_02.zed:0x000000CDr, "R mirror", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_02.zed:0x000000BFr, "FR window", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.zed:0x000000CDr, "R mirror", actcolor, optical, power );
		}
	}
}
